<?php
@session_start();
include("config.inc");
LOG_access(); //LOGGER

?>

<!DOCTYPE html><html lang="de">
<head>
	<!-- GOOGLE WEB FONTS //-->
	<link href='https://fonts.googleapis.com/css?family=Aldrich' rel='stylesheet' type='text/css'>
	<link href='https://fonts.googleapis.com/css?family=Actor' rel='stylesheet' type='text/css'>
	<link href='https://fonts.googleapis.com/css?family=Abel' rel='stylesheet' type='text/css'>
	<link href='https://fonts.googleapis.com/css?family=Shanti' rel='stylesheet' type='text/css'>
	<link href='https://fonts.googleapis.com/css?family=Oswald' rel='stylesheet' type='text/css'>
	<link href='https://fonts.googleapis.com/css?family=Inconsolata' rel='stylesheet' type='text/css'>
	<link href='https://fonts.googleapis.com/css?family=Cousine' rel='stylesheet' type='text/css'>
	<link href='https://fonts.googleapis.com/css?family=Yanone+Kaffeesatz' rel='stylesheet' type='text/css'>
	<link href='https://fonts.googleapis.com/css?family=Droid+Sans' rel='stylesheet' type='text/css'>
	<link href='https://fonts.googleapis.com/css?family=Droid+Sans+Mono' rel='stylesheet' type='text/css'>
	<link href='https://fonts.googleapis.com/css?family=Open+Sans' rel='stylesheet' type='text/css'>
	<link href='https://fonts.googleapis.com/css?family=Open+Sans+Condensed:300' rel='stylesheet' type='text/css'>
	<link href='https://fonts.googleapis.com/css?family=Allerta' rel='stylesheet' type='text/css'>

	<!-- IE8 HACK //-->
	<!--<meta http-equiv="X-UA-Compatible" content="IE=EmulateIE7" />//-->

	<meta charset="UTF-8">
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<meta http-equiv="x-ua-compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	
	<style>
		body,html { }
	</style>
	
	<title><?php echo _CONF_HTML_HEAD_title; ?></title>
	
	<link href="_css/index.css" rel="stylesheet" type="text/css" />

	
	
	<!-- JQUERY //-->
		<script type="text/javascript" src="_js/jquery-1.4.2.min.js"></script>
		<script>jQuery.noConflict();</script>
	<!-- jQUERY UI //-->
	<link type="text/css" href="_css/ui-lightness/jquery-ui-1.8.5.custom.css" rel="stylesheet" />
	<script type="text/javascript" src="_js/jquery-ui-1.8.5.custom.min.js"></script>
	
	
		<?php	if(_CONF_mediadir_subdirs_UI_accordion == "1"){	?>
			
			<script>
				jQuery(function(){
						// Accordion
						jQuery("#accordion").accordion({ 
							header: "h3",
							collapsible: true
						});
				});                                              

			</script>
			
		<?php	} ?>
		
			<!-- Shadowbox standalone modalwindowscript //-->
			
			<script type="text/javascript" src="_js/shadowbox/adapter/shadowbox-base.js"></script>
			<script type="text/javascript" src="_js/shadowbox/shadowbox.js"></script>
			<script>
				Shadowbox.loadLanguage(['en'], '_js/shadowbox/lang');
				Shadowbox.loadSkin('classic', '_js/shadowbox/skin');
				Shadowbox.loadPlayer(['iframe'], '_js/shadowbox/player');
				Shadowbox.loadPlayer(['html'], '_js/shadowbox/player');
				Shadowbox.loadPlayer(['img'], '_js/shadowbox/player');
				Shadowbox.loadPlayer(['flv'], '_js/shadowbox/player');
				
				window.onload = function(){
				    Shadowbox.init();
				};
	
			</script>

	<!-- MAIN js//-->
	<script type="text/javascript" src="_js/index.js"></script>
</head>
<body>
<div id="outer" style="">
		<div id="inner">
			
			<?php echo _CONF_HTML_BODY_title; ?>
			
			<?php 
				if(_CONF_SYS_RIGHTS_LOGIN != "1")
				{	## NO LOGIN REQUIRED
					$_FILESDATA = getMediaDirs();
					showMediaDirs($_FILESDATA);
					showDirmenu();
				}elseif(($_SESSION['loggedin'] == "1") && ($_REQUEST['logout'] == "1"))
				{
					//LOGOUT
					sysSession_unset();
					js_GO("index.php");
					
				}elseif(
				## LOGIN NEEDED
				(sysLogin_check($_REQUEST['user'],$_REQUEST['password'])) 
				|| ($_SESSION['loggedin'] == "1"))
				{	
					//SET SESSION
					sysSession_set();
					
					//LOGOUTLINK
					showLogout();
	
					//SHOW FILES
					$_FILESDATA = getMediaDirs();
					showMediaDirs($_FILESDATA);
					
					showDirmenu();
				}elseif(
				## WRONG LOGIN
				($_REQUEST['sent'])
				&& (!sysLogin_check($_REQUEST['user'],$_REQUEST['password'])
				))
				{	
					sysSession_unset();
					js_ALERT("User or password wrong!");
					js_BACK();
				}else{
				## SHOW LOGIN
					sysSession_unset();
					showLogin();
				}
			?>
<?php

function showLogout()
{
	echo '<a style="display: block; float: left; margin: 10px; width: 100%"" href="index.php?logout=1">[logout]</a>';
}

function sysLogin_check($DATA_user,$DATA_pwd)
{
	if(($DATA_user == _CONF_SYS_RIGHTS_LOGIN_user) && ($DATA_pwd == _CONF_SYS_RIGHTS_LOGIN_pass))
	{
		return true;
	}else{
		return false;
	}
}

function sysSession_set()
{
	$_SESSION['loggedin'] = "1";
}

function sysSession_unset()
{
	$_SESSION['loggedin'] = "0";
	@session_destroy();
}

function showLogin()
{
	echo'<h3>You need to login!</h3>';
	echo '	<form action="" name="formLogin" method="post">
			<input type="hidden" value="1" name="login" />
			<b>User:</b><br/> 
			<input name="user" value="" type="text" />
			<br/>
			<br/>
			<b>Password:</b><br/> 
			<input name="password" value="" type="password" />
			<br/>
			<br/>
			<input type="submit" value="Login!" name="sent" />
		</form>';
}


function getMediaDirs()
{
	//READ FILENAMES FROM DIR IN ARRAY
	//because else we would have the newest or oldest at first/end
	$_FILESDATA = array();
	
	//set mediadirectory
	if(_CONF_mediadir != "")
	{	$DIR_opendir = _CONF_mediadir;
		$DIR_mediadir = _CONF_mediadir."/";
	}else{
		$DIR_opendir = ".";
		$DIR_mediadir = "";
	}
	
	//Read Dir with media (and subdirs if set in config)
	if ($handle = opendir($DIR_opendir)) 
	{
   		
		while (false !== ($file = readdir($handle))) 
		{ 
			if(($file != ".") && ($file != "..") && ($file != "_images") && ($file != "_js") && ($file != "_css"))
			{
				//DO WE READ SUBDIRS OF MEDIADIR?
				if(_CONF_mediadir_subdirs_read == "1")
				{
					//read subdirs
					if((is_dir($file)) && ($file != "log"))
					{
	
						if ($handlesub = opendir($DIR_opendir."/".$file)) 
						{
							while (false !== ($filesub = readdir($handlesub)))
							{
								if(($filesub != ".") && ($filesub != ".."))
								{
									$_FILESDATA[] = $DIR_mediadir.$file."/".$filesub;
									
									//remember that a file was found in this subdir
									$Filesub_filefound = 1;
								}
							}
						   
							//remember name of dir if not empty
							//in an selfconstructed form that we find later again
							if($Filesub_filefound == 1)
							{
								$_FILESDATA[] = $file.".DIR";
							}
							
							$Filesub_filefound = 0; //reset for next subdir
							closedir($handlesub);
						}
					}else{
						//file is no subdir, normal files in mediadir
						$_FILESDATA[] = $DIR_mediadir.$file;
					}
				}else{
				    if(!is_dir($file))
				    {
					    //read no subdirs
					    $_FILESDATA[] = $DIR_mediadir.$file;
				    }
				}
			}
		}
		closedir($handle);
		
        }

	//order array with names
	sort($_FILESDATA);
	return $_FILESDATA;
}

function showMediaDirs($_FILESDATA)
{	
	$i=0;

	//parse Array
   	foreach($_FILESDATA as $_FILE)
	{
		
		if(stristr($_FILE,".mp3") || stristr($_FILE,".wav")) 
		{
			writeFileheader($_FILE,$_FILE,$i);
			writeAudioplayer($_FILE,$_FILE,$i);
			writeFilefooter($_FILE,$_FILE,$id);
			$i++;
		}
		if((stristr($_FILE,".flv")) || 
			(stristr($_FILE,".pdf")) ||
			(stristr($_FILE,".bmp")) ||
			(stristr($_FILE,".psd")) ||
			(stristr($_FILE,".jpg")) ||
			(stristr($_FILE,".png")) ||
			(stristr($_FILE,".gif")) ||
			(stristr($_FILE,".doc")) ||
			(stristr($_FILE,".txt")) ||
			//(stristr($_FILE,".wav")) ||
			(stristr($_FILE,".aif")) ||
			(stristr($_FILE,".rar")) ||
			(stristr($_FILE,".zip"))
			)
		{
			writeFileheader($_FILE,$_FILE,$i);
			writeFilelink($_FILE,$_FILE,$i);
			if((stristr($_FILE,".jpg")) || (stristr($_FILE,".png")) || (stristr($_FILE,".gif")))
			{	
				showImagePreview($_FILE,$_FILE,$i);
			}
			writeFilefooter($_FILE,$_FILE,$id);
			$i++;
		}
		if(stristr($_FILE,".mp4"))
		{
			writeFileheader($_FILE,$_FILE,$i);
			writeVideoplayer($_FILE,$_FILE,$i);
			writeFilefooter($_FILE,$_FILE,$id);
			$i++;
		}
		
		
		
		
		//selfmade identification for a dir
		if(stristr($_FILE,".DIR"))
		{
			if((_CONF_mediadir_subdirs_UI_accordion == "1") && ($GLOBALS['RUNTIME_subdir_accordionopen'] != "1"))
			{
				$GLOBALS['RUNTIME_subdir_accordionopen'] = "1";
				echo '	<div id="accordion" class="w-100">';
			}
			
			writeDirheader($_FILE);
			$GLOBALS['RUNTIME_subdir_divopen'] = "1";
		}
		
		//optional _info.dat with html code to display
		if(stristr($_FILE,".info"))
		{
			writeInfodata($_FILE);
		}
	}
	
	if($GLOBALS['RUNTIME_subdir_divopen'] == "1")
	{
		echo '		</div><!-- SUBDIR END //-->';
		$GLOBALS['RUNTIME_subdir_divopen'] = "0";
	}
	
	if((_CONF_mediadir_subdirs_UI_accordion == "1") && ($GLOBALS['RUNTIME_subdir_accordionopen'] == "1"))
	{                                                                                         
		$GLOBALS['RUNTIME_subdir_accordionopen'] = "0";
		echo '	</div><!-- Accordion end //-->';
	}
}

function writeInfodata($_FILE)
{
	if(stristr($_FILE,"/")){
		echo '	<div class="Page_Infotext"  style="">';
				include($_FILE);
		echo '	</div>';
	}else{	echo '	<div class="Site_Header float-left clear-both w-100"  style="">';
				include($_FILE);
		echo '	</div>';
	}
}

function writeDirheader($_FILE)
{
	if($GLOBALS['RUNTIME_subdir_divopen'] == "1")
	{
		echo '	</div><!-- SUBDIR END //-->';
		$GLOBALS['RUNTIME_subdir_divopen'] = "0";
	}
	
	echo '	<h3>
			<a style="text-decoration:none; font-size: 6px;" name="'.str_replace(".DIR","",$_FILE).'"></a>
			'.str_replace(".DIR","",str_replace("_"," ",$_FILE)).' 
		</h3>
		<div id="Files_Subdir" class="Files_Subdir">';
		
}

function makeDirmenuLinks()
{
	$_FILESDATA = getMediaDirs();
	$DIRMENU_links = "";
	$_DIRMENU_links = array();
	$n=1;
	$i=0;
	
	//parse Array
	foreach($_FILESDATA as $_FILE)
	{
		if(stristr($_FILE,".DIR"))
		{
			$_DIRMENU_links[] = $_FILE; 
		}
	}
	
	foreach($_DIRMENU_links as $DIRMENU_link)
	{	$DIRMENU_links .= '	<a href="#'.str_replace(".DIR","",$DIRMENU_link).'" data-link="'.str_replace(" ", "%20", str_replace(".DIR","",$DIRMENU_link)).'" class="dirmenu_link" id="dirmenu_link_'.$n.'">'.str_replace("_", " ", str_replace(".DIR","",$DIRMENU_link)).'</a>';
		
		if($i <= (count($_DIRMENU_links) - 2) ) 
		{ $DIRMENU_links .= " 	<div class=\"dirmenu_dividor\"> | </div>"; }
		
		$n++;
		$i++;
	}
	$DIRMENU_js = '		<script>
					function wigwam_RUNTIME_Location_Hash_onHashChange(){ 
						var hash = window.location.hash;
						var hashname = hash.replace("#","");
						console.log("onhashchange triggered");
						console.log(":: hash = " + hash + "");
						console.log(":: hashname = " + hashname + "");
						jQuery("a.dirmenu_link").removeClass("act");
						if(jQuery("a.dirmenu_link[data-link=\'" + hashname + "\']").attr("class")){
							jQuery("a.dirmenu_link[data-link=\'" + hashname + "\']").addClass("act");
						}
					};
					//trigger
						window.addEventListener("hashchange", wigwam_RUNTIME_Location_Hash_onHashChange); //onchange
						if(jQuery("a.dirmenu_link[data-link=\'" + window.location.hash.replace("#","") + "\']").attr("class")){
							wigwam_RUNTIME_Location_Hash_onHashChange(); //onstart
						}
				</script>
			';
	return $DIRMENU_links.$DIRMENU_js;	

}

function showDirmenu()
{
	if(_CONF_HTML_SHOW_MENUDIR == "1")
	{
		$DIRMENU_links = makeDirmenuLinks();
	
		echo '	<div id="dirmenu">';
		echo 		$DIRMENU_links;						
		echo '	</div>';
	}
}

function writeFileheader($fileurl,$filetitle,$id)
{
	$_fileext = explode(".",$fileurl);
	$fileext = $_fileext[1];
	$filetitle = str_replace("_"," ",$filetitle);
	$filetitle = str_replace(".".$fileext."","",$filetitle);
	$filetitle = str_replace("/"," / ",$filetitle);

	if(_CONF_mediadir_show_filelist == "0")//hide dir in filename
	{
		$filetitle = preg_replace('/(.*) \/ (.*)/', '$2', $filetitle);
	}
	
	echo'
		<div id="Filelist_'.$id.'" class="Filelist" style="">
			<span class="filelist_title">
				<span class="filelist_title_number">'.($id+1).'</span><span class="filelist_title_text"><b>&nbsp;'.str_replace("_", " ",$filetitle).' &nbsp;</b></span>
			</span>
			<br/>
			<div style="" class="Filelist_download">';
				if(_CONF_SYS_RIGHTS_download != "0")
				{	
					$downloader = "DOWNLOADER.php?fileurl=";
					if(_CONF_SYS_URI_ENCODE == "1") 
					{ 	$file_URI = base64_encode($fileurl)."&encoded=1"; 
					}else{ 	
						$file_URI = $fileurl; 
					}
					//since big zips (>100MB) seem to have a problem with DOWNLOADER.php and fail with a 500, 
					//link them directly
					if(stristr($fileurl,".zip")){
						$file_URI = $fileurl; 
						$downloader = "";
					}
					if(_CONF_SYS_URI_SHOWFILESIZE == "1") 
					{ 	$file_SIZE = ' ('.make_filesize($fileurl).')'; 
					}else{ 	$file_SIZE = ""; }
					
						echo '	<a style="" class="download_link" href="'.$downloader.''.$file_URI.'">
							&raquo;&nbsp;&nbsp;DOWNLOAD '.$fileext.$file_SIZE.'
						</a>';
				}
	echo'	</div>
	';
}

function make_filesize($fileurl)
{
	$filesize = filesize($fileurl);
	$filesize = ($filesize / 1024);//KB
	$filesize = ($filesize / 1024);//MB
	$filesize = number_format($filesize,2);
	$filesize .= "MB";
	return $filesize;
}

function writeFilelink($fileurl,$filetitle,$id)
{
	echo '<div style="display:block; float: left;"></div><br/>';
}
function showImagePreview($fileurl,$filetitle,$id)
{
	echo '	<a href="'.$fileurl.'" title="'.$filetitle.'" rel="shadowbox"><img src="'.$fileurl.'" alt="'.$id.'" class="filelist_preview-image"  border="0"></a>';
}                                                           

function writeAudioplayer($fileurl,$filetitle,$id)
{
	if(_CONF_SYS_player == 2)
	{
		echo'
		<div style="display:block; float: left;"><object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" 
		codebase="http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0" 
		width="279" height="28" id="MP3_MiniMiniplayer_'.$id.'" align="middle">
		<param name="allowScriptAccess" value="sameDomain" />
		<param name="movie" value="mp3player.swf?txt='.$filetitle.'&mp3url='.$fileurl.'&loop=false" />
		<param name="menu" value="false" /><param name="quality" value="high" />
		<param name="wmode" value="transparent" /><param name="bgcolor" value="#ffffff" />
		<embed src="mp3player.swf?txt='.$filetitle.'&mp3url='.$fileurl.'&loop=false" 
		menu="false" quality="high" wmode="transparent" bgcolor="#ffffff" width="279" 
		height="28" name="MP3_MiniMiniplayer_'.$id.'" align="middle" allowScriptAccess="sameDomain" 
		type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" />
	
		</object>
		</div>
		<br/>';
	
	}elseif(_CONF_SYS_player == 3){
		//HTML5
		$audio_type = 'audio/mpeg';
		if(stristr($fileurl,".wav")){
			$audio_type = 'audio/wav';
		}
		echo'
		<div style="display:block; float: left;">
			<audio width="279" height="28" id="MP3_MiniMiniplayer_'.$id.'" align="middle" controls>
				<source src="'.$fileurl.'" type="'.$audio_type.'">
			</audio>
		</div>
		<br/>';	
	}else{
		//POSAR PLAYER
		echo'
		<div style="display:block; float: left;"><object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" 
		codebase="http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0" 
		width="279" height="28" id="MP3_MiniMiniplayer_'.$id.'" align="middle">
		<param name="allowScriptAccess" value="sameDomain" />
		<param name="movie" value="posar_mp3player.swf?title='.$filetitle.'&file='.$fileurl.'" />
		<param name="menu" value="false" /><param name="quality" value="high" />
		<param name="wmode" value="transparent" /><param name="bgcolor" value="#ffffff" />
		<embed src="posar_mp3player.swf?title='.$filetitle.'&file='.$fileurl.'" 
		menu="false" quality="high" wmode="transparent" bgcolor="#ffffff" width="279" 
		height="28" name="MP3_MiniMiniplayer_'.$id.'" align="middle" allowScriptAccess="sameDomain" 
		type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" />
	
		</object>
		</div>
		<br/>';

	}
}

function writeVideoplayer($fileurl,$filetitle,$id)
{
	//HTML5
	$video_type = 'video/mp4';
	
	echo'
	<div style="display:block; float: left; width: 99%; margin-top: 20px;">
		<video width="99%" id="MP4_MiniMiniplayer_'.$id.'" align="middle" controls>
			<source src="'.$fileurl.'" type="'.$video_type.'">
		</video>
	</div>
	<br/>';	
}


function writeFilefooter($fileurl,$filetitle,$id)
{
	echo'</div>';
}

//MISCS
function LOG_access()
{
	##ADD TO COUNTER AS HTML
	decoct(umask(0777));
	$file 	= "log.access.html";
	if((file_exists($file)) && (is_writeable($file)))
	{
		clearstatcache();
		$fp 	= fopen($file,"r+");
		//read old
		$data_counter_downloads_old = fread($fp, filesize($file));
		//make new
		$data_counter_downloads_new = "<br/><br><br>\n\n";
		$data_counter_downloads_new = "<b>".time()." - ".date("Y-m-d | H:i:s")."</b><br/>\n";
		$data_counter_downloads_new .= "<hr>\n";
		$data_counter_downloads_new .= "<b>ACCESS</b><br/>\n";
		$data_counter_downloads_new .= "<b>REFERER:</b> ".$_SERVER['HTTP_REFERER']."<br/>\n";
		$data_counter_downloads_new .= "<b>AT TIME:</b> ".date("Y-m-d, l dS of F H:i:s")."<br/>\n";
		$data_counter_downloads_new .= "<b>FROM AGENT:</b> ".$_SERVER['HTTP_USER_AGENT']."<br/>\n";
		$data_counter_downloads_new .= "<b>FROM CLIENTIP:</b> ".gethostbyaddr($_SERVER['REMOTE_ADDR'])." (".$_SERVER['REMOTE_ADDR'].")<br/>\n";
		$data_counter_downloads_new .= "<hr><br/>\n";
		fwrite ($fp,$data_counter_downloads_new); 	//write file bitwise
		fclose($fp);
		clearstatcache();
	}
}

function js_ALERT($alert)
{
	echo '	<script>alert("'.$alert.'");</script>';
}

function js_GO($link)
{
	echo '	<script>document.location.href = "'.$link.'";</script>';
}

function php_GO($link)
{
	header("Location: ".$link."");
}

function js_BACK()
{
	echo '	<script>history.go(-1);</script>';
}

?>		</div>
	</div>
</body>
</html>

<?php
?>